/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.action.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.system.dao.CmOutPutDao;
import jp.mosp.system.dto.CmOutPutDto;
import jp.mosp.system.vo.OutPutMasterListVo;

public class OutPutMasterListAction extends MosPAction {

	// R}h
	private static final String CMD_CODE_LIST_SHOW      = "S1220";	// \
	private static final String CMD_CODE_LIST_SELECT    = "S1221";	// 
	private static final String CMD_CODE_LIST_RE_SEARCH = "S1222";	// Č
	private static final String CMD_CODE_LIST_SORT      = "S1223";	// \[g

	/**
	 * RXgN^
	 */
	public OutPutMasterListAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// vZǗmF
		confirmCalculateAuth();
		// VO̎擾
		OutPutMasterListVo vo;
		Object obj = session.getAttribute(MospConst.ATT_FORMER_VO);
		if (obj instanceof OutPutMasterListVo) {
			vo = (OutPutMasterListVo)obj;
			vo.clearMessage();
			vo.clearErrField();
		} else {
			vo = new OutPutMasterListVo();
		}		
		vo.clearMessage();
		vo.clearErrField();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
		// ͈̓v_EXg쐬
		vo.aryPltScope = getOutputScopeArray();
		// R}h̏
		if (cmd.equals(CMD_CODE_LIST_SHOW)) {
			// \
			// lɃZbg
			vo.setSearchmode(OutPutMasterListVo.SEARCH_OFF);
		} else if (cmd.equals(CMD_CODE_LIST_SELECT)) {
			// 
			vo.setParams(request);
			searchCodeList(vo);
			vo.setIsAscending(true);
			vo.initListInfo();
			// ɃZbg
			vo.setSearchmode(OutPutMasterListVo.SEARCH_ON);
		} else if (cmd.equals(CMD_CODE_LIST_RE_SEARCH)) {
			// Č
			if(vo.getSearchmode() == OutPutMasterListVo.SEARCH_ON){
				session.removeAttribute(MospConst.ATT_DTO);
				searchCodeList(vo);
				vo.setPageButton();
				sortList(vo);
			}
		} else if (cmd.equals(CMD_CODE_LIST_SORT)) {
			// \[g
			sortList(key1, vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * R[hXg
	 * @param vo VoCX^X
	 * @throws Exception
	 */
	private void searchCodeList(OutPutMasterListVo vo) throws Exception {
		// 
		CmOutPutDao dao = new CmOutPutDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		vo.setFields(dao.findForSearch(vo.getTxtCode(),vo.getTxtName(),vo.getPltScope()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryOutPutMaster().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}

	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(String key, OutPutMasterListVo vo) throws MospException {
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
	}

	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(OutPutMasterListVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}

	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private Comparator getComparator(String key, OutPutMasterListVo vo) throws MospException {
		Comparator comp = null;
		if (key.equals(vo.KEY_CODE)) {
			comp = new CompCode();
		} else if (key.equals(vo.KEY_NAME)) {
			comp = new CompName();
		} else if (key.equals(vo.KEY_SCOPE)) {
			comp = new CompScope();
		} else if (key.equals(vo.KEY_INDEX)) {
			comp = new CompIndex();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}

	/**
	 * R}hNo.ɂrNX
	 */
	protected static class CompCode implements Comparator, Serializable {
		private static final long serialVersionUID = 2092325382735270514L;
		public int compare(Object obj1, Object obj2) {
			CmOutPutDto dto1 = (CmOutPutDto)obj1;
			CmOutPutDto dto2 = (CmOutPutDto)obj2;
			return dto1.getCode().compareTo(dto2.getCode());
		}
	}

	/**
	 * {^̂ɂrNX
	 */
	protected static class CompName implements Comparator, Serializable {
		private static final long serialVersionUID = 1566211673543838675L;
		public int compare(Object obj1, Object obj2) {
			CmOutPutDto dto1 = (CmOutPutDto)obj1;
			CmOutPutDto dto2 = (CmOutPutDto)obj2;
			return dto1.getName().compareTo(dto2.getName());
		}
	}

	/**
	 * ͈͂ɂrNX
	 */
	protected static class CompScope implements Comparator, Serializable {
		private static final long serialVersionUID = -6641642982714466781L;
		public int compare(Object obj1, Object obj2) {
			CmOutPutDto dto1 = (CmOutPutDto)obj1;
			CmOutPutDto dto2 = (CmOutPutDto)obj2;
			return dto1.getScope().compareTo(dto2.getScope());
		}
	}

	/**
	 * \ɂrNX
	 */
	protected static class CompIndex implements Comparator, Serializable {
		private static final long serialVersionUID = 2867298555927778701L;
		public int compare(Object obj1, Object obj2) {
			CmOutPutDto dto1 = (CmOutPutDto)obj1;
			CmOutPutDto dto2 = (CmOutPutDto)obj2;
			return String.valueOf(dto1.getViewIndex()).compareTo(String.valueOf(dto2.getViewIndex()));
		}
	}

}
